#version 330
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Christmas Pillow Dance FloorMod01.fsh by   blackle
//https://www.shadertoy.com/view/ttcGRs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//CC0 1.0 Universal https://creativecommons.org/publicdomain/zero/1.0/
//To the extent possible under law, Blackle Mori has waived all copyright and related or neighboring rights to this work.

void erot(inout vec3 p, vec3 ax, float ro) {
  p = mix(dot(ax,p)*ax,p,cos(ro))+sin(ro)*cross(ax,p);
}

vec2 id;
float scene(vec3 p) {
  float scale=1.3;
  id = floor(p.xy/scale);
  p.xy = (fract(p.xy/scale)-0.5)*scale;
  erot(p,vec3(0,0,1),acos(-1.)*0.25);
  return (length(vec3(length(p.xy)-2.41, length(p.yz), length(p.zx))+0.8)-2.)/sqrt(2.);
}

vec3 norm(vec3 p) {
  mat3 k = mat3(p,p,p) - mat3(0.001);
  return normalize(scene(p) - vec3(scene(k[0]),scene(k[1]),scene(k[2])));
}

float smin(float a, float b, float k) {
  float h  = max(0.,k-abs(a-b))/k;
  return min(a,b)-h*h*h*k/6.;
}
vec3 smin(vec3 a, vec3 b, float k) {
  vec3 h = max(vec3(0.),k-abs(a-b))/k;
  return min(a,b)-h*h*h*k/6.;
}

#define FK(k) floatBitsToInt(k)^floatBitsToInt(cos(k))
float hash(vec2 p) {
  int x = FK(p.x); int y = FK(p.y);
  return float((x*x-y)*(y*y+x)+x)/2.14e9;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 uv = vec2(fragCoord - .5* iResolution.xy ) / iResolution.y;

  vec3 cam = normalize(vec3(0.9,uv));
  vec3 init = vec3(-4,0,0);
  erot(cam,vec3(0,1,0),0.8);
  erot(init,vec3(0,1,0),0.8);
  erot(cam,vec3(0,0,1),iTime/4.);
  erot(init,vec3(0,0,1),iTime/4.);
  vec3 p = init;
  bool hit = false;
  float mini = 1000.;
  for (int i = 0; i < 150; i++) {
    float dist = scene(p);
    mini = min(dist,mini);
    if (dist*dist < 0.00001) {hit = true; break;}
    if (distance(init, p) > 100.) break;
    p+= cam*dist;
  }
  vec3 n = norm(p);
  float factor = 2.5;
  float diffuse = length(sin(n*factor)*0.5+0.5)/sqrt(3.);
  float frensel = 1.-abs(dot(cam, n))*0.98;
  float spec = pow(length(sin(reflect(cam, n)*factor)*0.5+0.5)/sqrt(3.),8.);
  float hs = hash(vec2(hash(id),floor(iTime/60.*140.)));
  vec3 color = vec3(1);
  if (hs < 0.3) color = vec3(0.9,0.3,0.2);
  if (hs < -0.3) color = vec3(0.35,0.7,0.3);
  fragColor.xyz = hit ? color*diffuse+mix(color,vec3(1),0.9)*frensel*spec : vec3(0.75)*smoothstep(-0.05,0.05,mini);
  fragColor.xyz*=smoothstep(1.3,0.5,length(uv));
  fragColor.xyz=pow(fragColor.xyz,vec3(0.55,0.55,0.5));
  fragColor.xyz = smin(fragColor.xyz, vec3(0.99), 0.5)/0.99;
  fragColor.xyz=pow(fragColor.xyz+hash(uv+iTime)*0.03,vec3(1.5));
 //fragColor.a = 1.0;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc); //* gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = 1.0;
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

